<?php

    /* 
    Plugin Name: MyKeyworder Related Images 
    Plugin URI: http://www.mykeyworder.com/wordpressplugin/
    Description: Autosuggest Shutterstock images based on the Wordpress post content 
    Author: Sam Chadwick 
    Version: 2.0 
    Author URI: http://www.mykeyworder.com 
    */

    // LOAD THE SCRIPTS
	function mykeyworder_load_scripts($hook){
		if( 'post.php' != $hook && 'post-new.php' != $hook ) return;
		
    	wp_register_style('mykeyworder-smoothness', 'http://code.jquery.com/ui/1.10.3/themes/smoothness/jquery-ui.css');
    	wp_enqueue_style( 'mykeyworder-smoothness');

    	wp_register_style('mykeyworder-fancyboxcss', 'https://cdn.jsdelivr.net/gh/fancyapps/fancybox@3.5.6/dist/jquery.fancybox.min.css');
    	wp_enqueue_style( 'mykeyworder-fancyboxcss');

		wp_register_script('mykeyworder-button', plugin_dir_url(__FILE__).'js/mykeyworder.js', array('jquery','jquery-ui-tabs'));
		wp_enqueue_script('mykeyworder-button');

		wp_register_script('mykeyworder-fancyboxjs', 'https://cdn.jsdelivr.net/gh/fancyapps/fancybox@3.5.6/dist/jquery.fancybox.min.js');
		wp_enqueue_script('mykeyworder-fancyboxjs');

		global $post;
		$postid = $post->ID;
	    $content_post = get_post($postid);
		$content = $content_post->post_content;
		$content = str_replace('\"','',$content);
		$phrase = preg_replace("/[^a-zA-Z0-9\s]/", "", $content);
		$data = array('mykeyworder_phrase' => $phrase);
		wp_localize_script( 'mykeyworder-button', 'mykeyworder_jqpost_info', $data );
	}

	add_action('admin_enqueue_scripts','mykeyworder_load_scripts');

	// CREATE THE SETTINGS PAGE
	class MyKeyworderSettings
	{
		private $options;

		public function __construct()
		{
			add_action( 'admin_menu', array( $this, 'add_plugin_page' ) );
			add_action( 'admin_init', array( $this, 'page_init' ) );
		}

		public function add_plugin_page()
		{
			add_options_page(
				'Settings Admin', 
				'MyKeyworder', 
				'manage_options', 
				'mykeyworder-settings-admin', 
				array( $this, 'create_admin_page' )
			);
		}

		public function create_admin_page()
		{
			$this->options = get_option( 'mykeyworder_options' );
			?>
			<div class="wrap">
				<?php screen_icon(); ?>
				<h2>MyKeyworder</h2>           
				<form method="post" action="options.php">
				<?php
					settings_fields( 'mykeyworder_option_group' );   
					do_settings_sections( 'mykeyworder-settings-admin' );
					submit_button(); 
				?>
				</form>
			</div>
			<?php
		}

		public function page_init()
		{        
			register_setting(
				'mykeyworder_option_group',
				'mykeyworder_options',
				array( $this, 'sanitize' )
			);

			add_settings_section(
				'intro_text',
				'MyKeyworder Settings',
				array( $this, 'intro_text_callback' ),
				'mykeyworder-settings-admin'
			);  

			add_settings_field(
				'max_results',
				'Max number of Images',
				array( $this, 'max_results_callback' ),
				'mykeyworder-settings-admin',
				'intro_text'           
			);    

			add_settings_field(
				'sort',
				'Sort images',
				array( $this, 'sort_callback' ),
				'mykeyworder-settings-admin',
				'intro_text'           
			); 

			add_settings_field(
				'show_zeros',
				'Show Empty Tabs',
				array( $this, 'show_zeros_callback' ),
				'mykeyworder-settings-admin',
				'intro_text'           
			);

			add_settings_field(
				'image_type',
				'Image Types',
				array( $this, 'image_type_callback' ),
				'mykeyworder-settings-admin',
				'intro_text'           
			);

			add_settings_field(
				'model_released',
				'Model Releases',
				array( $this, 'model_release_callback' ),
				'mykeyworder-settings-admin',
				'intro_text'           
			);

			add_settings_field(
				'safe_for_work',
				'Safe for Work',
				array( $this, 'safe_for_work_callback' ),
				'mykeyworder-settings-admin',
				'intro_text'           
			);

			add_settings_field(
				'image_orientation',
				'Image Orientation',
				array( $this, 'image_orientation_callback' ),
				'mykeyworder-settings-admin',
				'intro_text'           
			);

			add_settings_field(
				'image_license',
				'Image License',
				array( $this, 'image_license_callback' ),
				'mykeyworder-settings-admin',
				'intro_text'           
			);
		}

		public function sanitize( $input )
		{
			$new_input = array();
			if( isset( $input['max_results'] ) )
			$new_input['max_results'] = sanitize_text_field( $input['max_results'] );

			if( isset( $input['sort'] ) )
			$new_input['sort'] = $input['sort'];

			if( isset( $input['show_zeros'] ) )
			$new_input['show_zeros'] = absint( $input['show_zeros'] );

			if( isset( $input['image_type'] ) )
			$new_input['image_type'] = $input['image_type'];

			if( isset( $input['model_release'] ) )
			$new_input['model_release'] = absint( $input['model_release'] );

			if( isset( $input['safe_for_work'] ) )
			$new_input['safe_for_work'] = absint( $input['safe_for_work'] );

			if( isset( $input['image_orientation'] ) )
			$new_input['image_orientation'] = $input['image_orientation'];

			if( isset( $input['image_license'] ) )
			$new_input['image_license'] = $input['image_license'];

			return $new_input;
		}

		public function intro_text_callback()
		{
			$status = file_get_contents('http://www.mykeyworder.com/checkplugin/2.0');

			print 'The MyKeyworder for Related images plugin allows you to have Shutterstock images recommended to you directly from within Wordpress.  There are a few settings that allow you to customize its behaviour<br>'.$status;
		}

		public function max_results_callback()
		{
			printf(
				'<input type="text" id="max_results" name="mykeyworder_options[max_results]" value="%s" />',
				isset( $this->options['max_results'] ) ? esc_attr( $this->options['max_results']) : ''
			);
	        	print '<br><small>Maximum number per keyword identified.  25 is default if left blank. Maximum allowed is 150.</small>';
		}

		public function sort_callback()
		{
			printf(
				'<input type="radio" id="sort" name="mykeyworder_options[sort]" value="relevance"'. checked( 'relevance', $this->options['sort'], false ) . '/>Relevance<br>
				<input type="radio" id="sort" name="mykeyworder_options[sort]" value="popular"'. checked( 'popular', $this->options['sort'], false ) . '/>Popular<br>
				<input type="radio" id="sort" name="mykeyworder_options[sort]" value="newest"'. checked( 'newest', $this->options['sort'], false ) . '/>Newest<br>
				<input type="radio" id="sort" name="mykeyworder_options[sort]" value="random"'. checked( 'random', $this->options['sort'], false ) . '/>Random
				');
	        	print '<br><small>Sort the desired images to be returned.  "Relevance" is default if left blank.  Random can be useful as it allows the same search to be run multiple times with different results.</small>';
		}

		public function show_zeros_callback()
		{
			printf(
				'<input type="checkbox" id="show_zeros" name="mykeyworder_options[show_zeros]" value="1"'. checked( 1, $this->options['show_zeros'], false ) . '/>');
			print '<br><small>Show keyword groups even if they have no images.</small>';
		}

		public function image_type_callback()
		{
			if(!isset($this->options['image_type'])){
				$this->options['image_type'] = array();
			}

			printf(
				'<input type="checkbox" name="mykeyworder_options[image_type][]" value="photo"'. checked( 1, in_array('photo',$this->options['image_type']), false ) . '/>Photographs<br>
				<input type="checkbox" name="mykeyworder_options[image_type][]" value="illustration"'. checked( 1, in_array('illustration',$this->options['image_type']), false ) . '/>Illustrations<br>
				<input type="checkbox" name="mykeyworder_options[image_type][]" value="vector"'. checked( 1, in_array('vector',$this->options['image_type']), false ) . '/>Vectors
				');
			print '<br><small>Limit the image results only to the selected types. "All Image Types" is default if left blank</small>';
		}

		public function model_release_callback()
		{
			printf(
				'<input type="checkbox" id="model_release" name="mykeyworder_options[model_release]" value="1"'. checked( 1, $this->options['model_release'], false ) . '/>');
			print '<br><small>Only show images that have model releases.</small>';
		}

		public function safe_for_work_callback()
		{
			printf(
				'<input type="checkbox" id="safe_for_work" name="mykeyworder_options[safe_for_work]" value="1"'. checked( 1, $this->options['safe_for_work'], false ) . '/>');
			print '<br><small>Only show images that are classified Safe for Work.</small>';
		}

		public function image_orientation_callback()
		{
			if(!isset($this->options['image_orientation'])){
				$this->options['image_orientation'] = array();
			}

			printf(
				'<input type="checkbox" id="image_orientation" name="mykeyworder_options[image_orientation][]" value="horizontal"'. checked( 1, in_array('horizontal',$this->options['image_orientation']), false ) . '/>Horizontal<br>
				<input type="checkbox" id="image_orientation" name="mykeyworder_options[image_orientation][]" value="vertical"'. checked( 1, in_array('vertical',$this->options['image_orientation']), false ) . '/>Vertical
				');
			print '<br><small>Only show images with this orientation. "All Orientations" is default if left blank</small>';
		}

		public function image_license_callback()
		{
			if(!isset($this->options['image_license'])){
				$this->options['image_license'] = array();
			}

			printf(
				'<input type="checkbox" id="image_license" name="mykeyworder_options[image_license][]" value="commercial"'. checked( 1, in_array('commercial',$this->options['image_license']), false ) . '/>Commercial<br>
				<input type="checkbox" id="image_license" name="mykeyworder_options[image_license][]" value="editorial"'. checked( 1, in_array('editorial',$this->options['image_license']), false ) . '/>Editorial<br>
				<input type="checkbox" id="image_license" name="mykeyworder_options[image_license][]" value="enhanced"'. checked( 1, in_array('enhanced',$this->options['image_license']), false ) . '/>Enhanced<br>
				<input type="checkbox" id="image_license" name="mykeyworder_options[image_license][]" value="sensitive"'. checked( 1, in_array('sensitive',$this->options['image_license']), false ) . '/>Sensitive
				');
			print '<br><small>Only show images with the selected licenses available. "All Licenses" is default if left blank<br>See the <a href="https://www.shutterstock.com/en/support/pkb_sstk_core_customerkb_home?c=CustomerKB%3AImages">Shutterstock website</a> for common Q&A about licenses.</small>';
		}
	}

	// CREATE THE EDIT POST METABOX
	class MyKeyworderMetabox
	{
		function __construct() {
	        add_action('add_meta_boxes', array( $this, 'mykeyworder_add_post_meta_boxes'));
	    }

	    function mykeyworder_add_post_meta_boxes() {
			add_meta_box(
				'mykeyworder-post-metabox',
				__( 'Recommended Images by MyKeyworder', 'Recommend Images' ),
				array( $this,'mykeyworder_build_metabox'),
				'post',
				'normal',
				'high'
			);
		}
	 
		function mykeyworder_build_metabox() {
			?>
			<div class="wrap">
				<button type="button" id="mykeyworder_button" class="button-secondary" /><?php _e('Find Related Images on Shutterstock','mykeyworder'); ?></button><br><br>
				<div class ="wrap" id="wait">
					<script>
						$('#wait').hide();
					</script>
				</div>
				<div id="mykeyworder_results"></div>
			</div>
			<?php
		}
	}


	// DEFINE THE BEHAVIOUR OF THE FIND IMAGES REQUEST TO MYKEYWORDER
	function mykeyworder_find_images (){
		
		// get user options
	    $options = get_option( 'mykeyworder_options' );
		$max = $options['max_results'];
		$sort = $options['sort'];
		$show_zeros = $options['show_zeros'];
		$release = $options['model_release'];
		$safe = $options['safe_for_work'];
		$image_type = $options['image_type'];
		$image_orientation = $options['image_orientation'];
		$image_license = $options['image_license'];
	        
	    // get blog post content
	    $data['phrase'] = urlencode($_POST['val']);
	    $data['max'] = urlencode($max);
	    $data['sort'] = urlencode($sort);
	    $data['show_zeros'] = urlencode($show_zeros);
	    $data['model_release'] = urlencode($release);
	    $data['safe'] = urlencode($safe);
	    $data['image_type'] = urlencode(implode(',',$image_type));
	    $data['image_orientation'] = urlencode(implode(',',$image_orientation));
	    $data['image_license'] = urlencode(implode(',',$image_license));
	    $data = http_build_query($data);
	        
		//generate keywords
		$ch = curl_init();
	    curl_setopt($ch, CURLOPT_URL, 'https://mykeyworder.com/api/wordpress.php');
	    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	    curl_setopt($ch, CURLOPT_HEADER, 0);
	    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
	    curl_setopt($ch, CURLOPT_POST, 1);
	    $results = curl_exec($ch);
	    curl_close($ch);

		$image_results = json_decode($results);
	   		
	   	// build results display
	   	if (isset($image_results->error)){
	   		echo $image_results->error;
		} else {
			$n = 1;
			//prepare tabs
			echo '<script>
				$(function() {
					$( "#mykeyworder-tabs" ).tabs();
				});
				</script>';
			echo '<div id="mykeyworder-tabs"><ul>';
			// tab headers
			foreach ($image_results as $category => $array){
				$category = str_replace("_"," / ",$category);
				$category = str_replace("+"," ",$category);
				$category = str_replace(" - ","-",$category);
				echo '<li><a href="#tabs-'.$n.'">'.$category.'</a></li>';
				$n++;
			}
			echo '</ul>';
			// tab contents
	   		$n = 1;
	   		foreach ($image_results as $category => $array){
				echo '<div id="tabs-'.$n.'">';
				echo '<p>';
				//echo $value->pre;
				foreach ($array as $image){
					echo '<div style="display: inline-block;"><a data-fancybox="gallery-'.$n.'" href="'.$image->assets->preview->url.'" data-caption="'.$image->description.'<br>'.$image->id.'<br><br><br>"><img src="'.$image->assets->large_thumb->url.'"></a><br>'.$image->id.'</div>';
				}
				//echo $value->more;
				echo '</p></div>';
				$n++;
	        }
	        echo '</div>';
	   	}
		die();
	}

	add_action('wp_ajax_mykeyworder_get_results','mykeyworder_find_images');

    $mykeyworder_settings_page = new MyKeyworderSettings();
	$mykeyworder_settings_page = new MyKeyworderMetabox();
?>